IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'EST_NF_SAI_TRANSF_DEMANDA') 
					AND type in (N'U')) 
BEGIN
CREATE TABLE [dbo].[EST_NF_SAI_TRANSF_DEMANDA](
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_NF] [int] NOT NULL,
	[CD_FILIAL_DEMANDA] [int] NOT NULL,
	[TIPO_OPERACAO] [int] NOT NULL,
 CONSTRAINT [PK_EST_NF_SAI_TRANSF_DEMANDA] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_FILIAL] ASC,
	[CD_NF] ASC,
	[CD_FILIAL_DEMANDA] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY],
 CONSTRAINT [IX_EST_NF_SAI_TRANSF_DEMANDA] UNIQUE NONCLUSTERED 
(
	[CD_EMP] ASC,
	[CD_FILIAL] ASC,
	[CD_NF] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[EST_NF_SAI_TRANSF_DEMANDA] ADD  CONSTRAINT [DF_EST_NF_SAI_TRANSF_DEMANDA_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[EST_NF_SAI_TRANSF_DEMANDA] ADD  CONSTRAINT [DF_EST_NF_SAI_TRANSF_DEMANDA_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[EST_NF_SAI_TRANSF_DEMANDA] ADD  CONSTRAINT [DF_EST_NF_SAI_TRANSF_DEMANDA_CD_NF]  DEFAULT ((0)) FOR [CD_NF]

ALTER TABLE [dbo].[EST_NF_SAI_TRANSF_DEMANDA] ADD  CONSTRAINT [DF_EST_NF_SAI_TRANSF_DEMANDA_CD_FILIAL_DEMANDA]  DEFAULT ((0)) FOR [CD_FILIAL_DEMANDA]

ALTER TABLE [dbo].[EST_NF_SAI_TRANSF_DEMANDA] ADD  CONSTRAINT [DF_EST_NF_SAI_TRANSF_DEMANDA_TIPO_OPERACAO]  DEFAULT ((0)) FOR [TIPO_OPERACAO]

ALTER TABLE [dbo].[EST_NF_SAI_TRANSF_DEMANDA]  WITH CHECK ADD  CONSTRAINT [FK_EST_NF_SAI_TRANSF_DEMANDA_EST_NF_SAI] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_NF])
REFERENCES [dbo].[EST_NF_SAI] ([CD_EMP], [CD_FILIAL], [CD_NF])

ALTER TABLE [dbo].[EST_NF_SAI_TRANSF_DEMANDA] CHECK CONSTRAINT [FK_EST_NF_SAI_TRANSF_DEMANDA_EST_NF_SAI]

ALTER TABLE [dbo].[EST_NF_SAI_TRANSF_DEMANDA]  WITH CHECK ADD  CONSTRAINT [FK_EST_NF_SAI_TRANSF_DEMANDA_PRC_FILIAL_TRANSF_DEMANDA] FOREIGN KEY([TIPO_OPERACAO], [CD_EMP], [CD_FILIAL], [CD_FILIAL_DEMANDA])
REFERENCES [dbo].[PRC_FILIAL_TRANSF_DEMANDA] ([TIPO_OPERACAO], [CD_EMP], [CD_FILIAL], [CD_FILIAL_DEMANDA])

ALTER TABLE [dbo].[EST_NF_SAI_TRANSF_DEMANDA] CHECK CONSTRAINT [FK_EST_NF_SAI_TRANSF_DEMANDA_PRC_FILIAL_TRANSF_DEMANDA]
end